% 
% Generate Tables 7-3, 7-4 and 7-9 in the book
%
% Dongrui WU (dongruiw@usc.edu), 5/5/2008

clc
clear all
close all

format bank

%% Read Data
[A,words] = xlsread('data72.xls');
words=words(1,1:2:end);
[row, col] = size(A);

%%  Compute the FOUs and centroids without specifying Very Small
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    [MFs(i,:), nums(i,:)] = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end

%% Sort the MFs in ascending order according to the centers of centroids
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);
words1=words(index); % Reorder the names of words
nums=nums(index,:)
latexMFs(MFs,char(words1))

for i=1:col/2
    for j=1:col/2
        sim(i,j)=Jaccard(MFs(i,:), MFs(j,:));
    end
end
sim

